
/*************************************************************************
 *           Copyright (C) 2003 by Freescale.  All rights reserved.      *
 *************************************************************************
 *                                                                       *
 *   Freescale reserves the right to make changes without further notice *
 *   to any product herein to improve reliability, function or design.   *
 *   Freescale does not assume any liability arising out of the          *
 *   application or use of any product, circuit, or software described   *
 *   herein; neither does it convey any license under its patent rights  *
 *   nor the rights of others.                                           *
 *                                                                       *
 *   Freescale products are not designed, intended, or authorized for    *
 *   use as components in systems intended for surgical implant into     *
 *   the body, or other applications intended to support life, or for    *
 *   any other application in which the failure of the Freescale product *
 *   could create a situation where personal injury or death may occur.  *
 *                                                                       *
 *   Should Buyer purchase or use Freescale products for any such        *
 *   unintended or unauthorized application, Buyer shall idemnify and    *
 *   hold Freescale and its officers, employees, subsidiaries,           *
 *   affiliates, and distributors harmless against all claims costs,     *
 *   damages, and expenses, and reasonable attorney fees arising out     *
 *   of, directly or indirectly, any claim of personal injury or death   *
 *   associated with such unintended or unauthorized use, even if such   *
 *   claim alleges that Freescale was negligent regarding the design     *
 *   or manufacture of the part.                                         *
 *                                                                       *
 *   Freescale and the Freescale logo* are registered trademarks of      *
 *   Freescale Ltd.                                                      *
 *                                                                       *
 *************************************************************************

 *************************************************************************
 *                                                                       *
 *                Freescale's H7F Flash Memory for MPC55xx               *
 *                        Standard Software Driver                       *
 *                      Demo with SSD in C-Array format                  *
 *                                                                       *
 * FILE NAME     :  censorship_recovery_ssd.c                          	 *
 * VERSION:      :  1.00                                                 *
 * DATE          :  June 12, 2008                                        *
 * INFO			 :  Uses standard software driver to erase & restore     *
 *					shadow row information.  							 *
 *                                                                       *
 *************************************************************************/

/************************ Revision History *******************************
 0.1	David connelly 	06-12-08		- Initial Release.
 *************************************************************************/

#include "m_h7f.h"
#include "ssd_h7f.h" 

typedef unsigned int UINT32;
#define NO_INTERRUPTS 		1 //** Define this globally in your project if needed - used in z650_init_debug.c **
#define W32(addr, value)  	(*((UINT32 *) (addr)) = (value))		//write 32 bits of data
#define FLASH               (*( struct H7F_tag *) 0xC3F88000)      				//point to flash registers (0xFFFF8000 for MPC551x)

#define SHADOW_ADDRESS		0x00FFFC00 
#define CENSORSHIP_ADDR		0x00FFFDE0
#define SERIAL_BOOT1_ADDR	0x00FFFDD8
#define SERIAL_BOOT2_ADDR	0x00FFFDDC
#define SERIAL_PASSWORD1	0xFEEDFACE
#define SERIAL_PASSWORD2	0xCAFEBEEF
#define LOW_ADDR_KEY		0xA1A11111
#define S_LOW_ADDR_KEY		0xC3C33333
#define CENSORSHIP_WORD		0x55AA55AA
#define LOW_ADDR_SR_UNLOCK	0x800FFFFF
#define	LBLOCK0				0x00000001						
#define	NOBLOCK				0				
#define DRIVER_BUFFER_SIZE	150			//max size of driver in words

SSD_CONFIG ssdConfig = {
    H7F_CTL_REG_BASE,       /* H7F control register base */
    FLASH_ARRAY_BASE,       /* base of main array */
    0,                      /* size of main array */
    0,        				/* base of shadow row */
    0,        				/* size of shadow row */
    0,                      /* block number in low address space */
    0,                      /* block number in middle address space */
    0,                      /* block number in high address space */
    0,        				/* flash page size selection */
    FALSE                   /* debug mode selection */
};

extern const UINT32 FlashErase_C[];
extern const UINT32 FlashProgram_C[];

UINT32 ssd_RAM[DRIVER_BUFFER_SIZE];
void CopyFunction(const UINT32 function[], UINT32 ram_destination[], UINT32 size);   //only used if running code out of flash

// RUN_FROM_FLASH -->> Used for executing this code out of flash.  
// Functions running from flash block need to be copied to RAM in order to erase shadow block since 
// they are in the same flash partition (RWW restriction)
//#define RUN_FROM_FLASH  	1

void main(void) 
{
	UINT32 data[2], status;
		
	pFLASHERASE    FlashErase    = (pFLASHERASE)    FlashErase_C;
	pFLASHPROGRAM  FlashProgram  = (pFLASHPROGRAM)  FlashProgram_C;

	// enable shadow space 
	FLASH.LML.R = LOW_ADDR_KEY;
	FLASH.LML.R = LOW_ADDR_SR_UNLOCK;
	FLASH.SLL.R = S_LOW_ADDR_KEY;
	FLASH.SLL.R = LOW_ADDR_SR_UNLOCK; 

	// Setup ssd with proper parameters for shadow row
	ssdConfig.h7fRegBase = H7F_CTL_REG_BASE;
	ssdConfig.mainArrayBase = FLASH_ARRAY_BASE;
    ssdConfig.shadowRowBase = SHADOW_BASE_1K;
    ssdConfig.shadowRowSize = ONE_KB;
    ssdConfig.pageSize = H7FA_PAGE_SIZE; 

	#if RUN_FROM_FLASH  
		CopyFunction(FlashErase_C, ssd_RAM, DRIVER_BUFFER_SIZE);
		FlashErase = (pFLASHERASE) ssd_RAM;
	#endif
	
	// Erase Shadow Row	
	status = FlashErase(&ssdConfig, TRUE, NOBLOCK, NOBLOCK, NOBLOCK, NULL_CALLBACK);

	#if RUN_FROM_FLASH  
		CopyFunction(FlashProgram_C, ssd_RAM, DRIVER_BUFFER_SIZE);
		FlashProgram = (pFLASHPROGRAM) ssd_RAM;
	#endif	

	// program serial password
	data[0] = SERIAL_PASSWORD1;
	data[1] = SERIAL_PASSWORD2;
	status = FlashProgram(&ssdConfig, 0x00FFFDD8, 8, (UINT32)data, NULL_CALLBACK);
	
	// program censorship and serial boot info
	data[0] = CENSORSHIP_WORD;
	data[1] = 0xffffffff;
	status = FlashProgram(&ssdConfig, 0x00FFFDE0, 8, (UINT32)data, NULL_CALLBACK);
	
	while(1);
}

void CopyFunction(const UINT32 function[], UINT32 sram_addr[], UINT32 size)
{
	UINT32 i;
	
	//Number of 32 bit words passed in, so just copy it over
	for (i = 0; i < size; i++)
	{
		sram_addr[i] = function[i];
	}
}
	